# Rolemapper Deployment (Docker + Traefik)

This bundle contains:
- Program files (`app/`, `requirements.txt`, optional `README.md`)
- `config/` (embedded defaults, roles/personas/settings)
- `docker-compose.example.yaml`
- `Dockerfile`
- `DEPLOY_EN.md`
- `config/auth_settings.json` (with initial admin password hash)
- `app/CHANGELOG_BUNDLED.md` (embedded changelog fallback)

Note: `Aufgabe/` is intentionally NOT included in this bundle.

## Initial admin login
- Username: not required (password only)
- Initial admin password: `Rm-Init#2026-Safe`
- Please change the admin password immediately after first login in `Auth configuration`.

## 1) Prepare folder
Extract this bundle into your deployment directory, e.g. `/opt/rolemapper`.

## 2) Check compose values
Open `docker-compose.example.yaml` and adjust:
- Hostname rule (Traefik label)
- Certificate resolver name
- External Docker network name
- Volume paths

## 2a) Traefik TLS checklist (recommended)
For HTTPS with Let's Encrypt, make sure these labels are present on the rolemapper service:
- `traefik.http.routers.rolemapper.entrypoints=https`
- `traefik.http.routers.rolemapper.tls=true`
- `traefik.http.routers.rolemapper.tls.certresolver=<your-certresolver-name>`
- `traefik.http.services.rolemapper.loadbalancer.server.port=5080`
- `traefik.docker.network=<your-traefik-network>`

Common pitfall:
- If `tls.certresolver` is missing, Traefik routes traffic but does not request/store a Let's Encrypt cert for this router.
- The certresolver value must match your Traefik configuration name exactly (example only: `le`).

## 3) Start
```bash
cd /opt/rolemapper
docker compose -f docker-compose.example.yaml up -d --build
```

## 4) Verify
```bash
docker compose -f docker-compose.example.yaml ps
docker compose -f docker-compose.example.yaml logs -f
```
Then open your configured HTTPS URL.

## 5) Updates
When code changes:
```bash
docker compose -f docker-compose.example.yaml up -d --build
```

Bundle generated from Rolemapper 0.2.1.
